/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809.dasm;

import frc.emul.api.IAddressBinder;
import frc.emul.api.IReadOnlyMemory;
import frc.emul.api.MemoryNotAvailableException;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.MC6809Sim;
import frc.emul.mc6809.Operand;
import frc.emul.mc6809.dasm.DasmRegs;
import frc.emul.mc6809.dasm.IDasmRegs;
import frc.emul.util.Utils;

public class DasmCore {
    public static final int COMMENTS_COLUMN = 51;
    private static final char HEX_SEP = '\u00b7';
    public static String LABEL_HEADER = "L_";
    private IAddressBinder binder;
    private IDasmRegs regs;
    private IReadOnlyMemory mem;
    private StringBuffer hexa;
    private StringBuffer line;
    private StringBuffer comment;
    private int opcodeAddr;
    private int fetchAt;
    private boolean createLabels;
    private boolean pureASM;

    public DasmCore() {
        this.setRegisters(null);
    }

    public DasmCore(IReadOnlyMemory iReadOnlyMemory, IDasmRegs iDasmRegs, IAddressBinder iAddressBinder) {
        this(iReadOnlyMemory, iDasmRegs, iAddressBinder, false, false);
    }

    public DasmCore(IReadOnlyMemory iReadOnlyMemory, IDasmRegs iDasmRegs, IAddressBinder iAddressBinder, boolean bl, boolean bl2) {
        this.mem = iReadOnlyMemory;
        this.binder = iAddressBinder;
        this.setRegisters(iDasmRegs);
        this.pureASM = bl2;
        this.createLabels = bl;
    }

    public synchronized void setMemory(IReadOnlyMemory iReadOnlyMemory) {
        this.mem = iReadOnlyMemory;
    }

    public synchronized void setRegisters(IDasmRegs iDasmRegs) {
        this.regs = iDasmRegs == null ? DasmRegs.UNAVAILABLE_REGS : iDasmRegs;
    }

    public synchronized void setAddrBinder(IAddressBinder iAddressBinder) {
        this.binder = iAddressBinder;
    }

    public static final StringBuffer format(int n, StringBuffer stringBuffer, StringBuffer stringBuffer2, StringBuffer stringBuffer3) {
        StringBuffer stringBuffer4 = new StringBuffer(70);
        Utils.HEX(4, n, stringBuffer4).append("  [").append(Utils.pad(14, '.', stringBuffer)).append("]  ").append(stringBuffer2);
        if (stringBuffer3 != null && stringBuffer3.length() > 0) {
            Utils.pad(50, ' ', stringBuffer4).append(" ; ").append(stringBuffer3);
        }
        return stringBuffer4;
    }

    public static final StringBuffer format(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer(70);
        stringBuffer3.append("        ").append(stringBuffer);
        if (stringBuffer2 != null && stringBuffer2.length() > 0) {
            Utils.pad(44, ' ', stringBuffer3).append(" ; ").append(stringBuffer2);
        }
        return stringBuffer3;
    }

    public synchronized StringBuffer DASM(Instruction instruction, int n, String string, boolean bl) {
        this.prepare(instruction, n, bl);
        StringBuffer stringBuffer = string == null ? this.comment : new StringBuffer(string);
        return this.pureASM ? DasmCore.format(this.line, stringBuffer) : DasmCore.format(n - instruction.getOpcodeLen(), this.hexa, this.line, stringBuffer);
    }

    public synchronized StringBuffer[] DASM(Instruction instruction, int n, StringBuffer[] stringBufferArray, char c, int n2, boolean bl) {
        if (stringBufferArray == null || stringBufferArray.length != 3) {
            stringBufferArray = new StringBuffer[3];
        }
        this.prepare(instruction, n, bl);
        stringBufferArray[0] = this.hexa;
        stringBufferArray[1] = this.line;
        stringBufferArray[2] = this.comment;
        if (c != '\u0000') {
            Utils.pad(14, c, this.hexa);
        }
        if (n2 > 0) {
            Utils.pad(n2, ' ', this.line);
        }
        return stringBufferArray;
    }

    public synchronized String DASM_regs(Instruction instruction, int n, boolean bl) {
        this.prepare(instruction, n, bl);
        String string = Utils.shortRegs(this.regs);
        return String.valueOf(string) + "  " + this.line.toString();
    }

    public int getNextFetchAddress() {
        return this.fetchAt;
    }

    public int getInstructionAddress() {
        return this.opcodeAddr;
    }

    private void prepare(Instruction instruction, int n, boolean bl) {
        this.opcodeAddr = n - instruction.getOpcodeLen();
        this.fetchAt = n;
        this.hexa = new StringBuffer(16);
        this.line = new StringBuffer(instruction.getName());
        if (this.comment == null || this.comment.length() > 0) {
            this.comment = new StringBuffer();
        }
        int n2 = instruction.getOpcode();
        if (instruction.isPage0()) {
            Utils.HEX(2, n2, this.hexa);
        } else {
            Utils.HEX(2, n2 & 0xFF, Utils.HEX(2, n2 >> 8, this.hexa).append('\u00b7'));
        }
        if (!instruction.isDocumented()) {
            this.comment.append("Undocumented opcode. ");
        }
        Utils.pad(6, ' ', this.line.append(' '));
        switch (instruction.getMode()) {
            case IMPLIED: {
                this.prepareImplied(instruction);
                break;
            }
            case IMMEDIATE: {
                int n3;
                String string;
                int n4;
                boolean bl2 = instruction.isTargetReg8();
                int n5 = n4 = bl2 ? this.readU8() : this.readU16();
                if (n4 < 10) {
                    this.line.append('#').append(n4);
                    break;
                }
                bl &= !bl2;
                String string2 = string = this.binder == null ? null : this.binder.getLabel(n4);
                if (string != null) {
                    if (bl) {
                        this.line.append("#").append(string);
                        Utils.HEX(4, n4, this.comment.append('$'));
                        break;
                    }
                    Utils.HEX(1, n4, this.line.append("#$"));
                    if (n4 < 4096) {
                        Utils.HEX(4, n4, this.comment.append('$')).append(" = ");
                    }
                    this.comment.append(string);
                    break;
                }
                if (n4 >= 256 && ((n3 = 0xEFFF & instruction.getOpcode()) == 206 || n3 == 142) && bl && this.createLabels && this.mem.isValidArea(n4, 1)) {
                    this.binder.bind(n4, String.valueOf(LABEL_HEADER) + Utils.HEX(4, n4));
                }
                Utils.HEX(1, n4, this.line.append("#$"));
                break;
            }
            case DIRECT: {
                int n6 = this.readU8();
                if (this.regs.isDPAvailable(this.opcodeAddr)) {
                    this.appendAddr(n6 |= this.regs.getDP(this.opcodeAddr) << 8, true, true, this.line.append('<'));
                    break;
                }
                Utils.HEX(2, n6, this.line.append("<$"));
                break;
            }
            case EXTENDED: {
                this.appendAddr(this.readU16(), false, true, this.line);
                break;
            }
            case RELATIVE8: {
                this.appendBxxComment(instruction);
                int n7 = this.readS8();
                this.appendAddr(this.fetchAt + n7, false, true, this.line);
                break;
            }
            case RELATIVE16: {
                this.appendBxxComment(instruction);
                int n8 = this.readS16();
                this.appendAddr(this.fetchAt + n8, false, true, this.line);
                break;
            }
            case INDEXED: {
                this.prepareIndexed(instruction);
            }
        }
    }

    private void prepareImplied(Instruction instruction) {
        Operand[] operandArray;
        switch (instruction.getOp()) {
            case REGISTER: {
                int n = this.readU8();
                Operand operand = MC6809Sim.decodeEXG(n, true);
                Operand operand2 = MC6809Sim.decodeEXG(n, false);
                this.appendRegName(operand2, this.appendRegName(operand, this.line).append(','));
                if (operand == Operand.CONSTANT || operand2 == Operand.CONSTANT) {
                    this.comment.append("Undocumented feature : $FFFF operand");
                } else if (operand.isReg8() != operand2.isReg8()) {
                    this.comment.append("Undocumented feature : 8/16 bits mixing");
                }
                return;
            }
            case REG_U: {
                operandArray = MC6809Sim.STACK_U_REGS;
                break;
            }
            case REG_S: {
                operandArray = MC6809Sim.STACK_S_REGS;
                break;
            }
            default: {
                return;
            }
        }
        boolean bl = true;
        int n = this.readU8();
        if ((instruction.getOpcode() & 1) == 0) {
            int n2 = 0;
            int n3 = 128;
            while (n3 != 0) {
                if ((n & n3) != 0) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.line.append(',');
                    }
                    this.appendRegName(operandArray[n2], this.line);
                }
                ++n2;
                n3 >>= 1;
            }
        } else {
            int n4 = 8;
            int n5 = 1;
            while (--n4 >= 0) {
                if ((n & n5) != 0) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.line.append(',');
                    }
                    this.appendRegName(operandArray[n4], this.line);
                }
                n5 <<= 1;
            }
        }
    }

    private void prepareIndexed(Instruction instruction) {
        boolean bl;
        boolean bl2;
        int n = this.readU8();
        boolean bl3 = bl2 = n > 128 && (n & 0x10) != 0;
        if (bl2) {
            this.line.append('[');
        }
        int n2 = this.prepareIndexed(instruction, n);
        if (bl2) {
            this.line.append(']');
        }
        if (n2 < 0) {
            return;
        }
        boolean bl4 = bl = n == 159;
        if (bl || bl2) {
            if (bl) {
                Utils.HEX(4, n2, this.comment.append("[$")).append("] = ");
            } else {
                this.appendComment(n2, this.comment.append('[')).append("] = ");
            }
            try {
                n2 = this.mem.readU16(n2);
            }
            catch (MemoryNotAvailableException memoryNotAvailableException) {
                this.comment.append("Unavailable content");
                return;
            }
            catch (Exception exception) {
                this.comment.append("Invalid address!");
                return;
            }
        }
        this.appendComment(n2, this.comment);
    }

    private int prepareIndexed(Instruction instruction, int n) {
        Operand operand;
        int n2;
        IDasmRegs iDasmRegs;
        block28: {
            String string;
            block27: {
                if (n == 159) {
                    int n3 = this.readU16();
                    this.appendAddr(n3, false, false, this.line);
                    return n3;
                }
                iDasmRegs = this.regs;
                n2 = 0;
                if ((n & 0x8E) == 140) {
                    n2 = (n & 1) == 0 ? this.readS8() : this.readS16();
                    return this.appendIdxOffset(n2, Operand.REG_PC);
                }
                switch (n & 0x60) {
                    case 0: {
                        operand = Operand.REG_X;
                        break;
                    }
                    case 32: {
                        operand = Operand.REG_Y;
                        break;
                    }
                    case 64: {
                        operand = Operand.REG_U;
                        break;
                    }
                    case 96: {
                        operand = Operand.REG_S;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Dead Code");
                    }
                }
                string = operand.getName();
                if (n < 128) {
                    n2 = n & 0x1F;
                    if (n2 >= 16) {
                        n2 |= 0xFFFFFFF0;
                    }
                    return this.appendIdxOffset(n2, operand);
                }
                if ((n & 0x8C) != 128) break block27;
                switch (n & 0x1F) {
                    case 0: {
                        this.line.append(',').append(string).append('+');
                        break block28;
                    }
                    case 1: 
                    case 17: {
                        this.line.append(',').append(string).append("++");
                        break block28;
                    }
                    case 2: {
                        this.line.append(",-").append(string);
                        n2 = -1;
                        break block28;
                    }
                    case 3: 
                    case 19: {
                        this.line.append(",--").append(string);
                        n2 = -2;
                        break block28;
                    }
                    default: {
                        this.line.append(",??").append(string).append("??");
                        return -1;
                    }
                }
            }
            switch (n & 0x8F) {
                case 132: {
                    this.line.append(',').append(string);
                    break;
                }
                case 133: {
                    this.line.append("B,").append(string);
                    if (!iDasmRegs.isAvailable(Operand.REG_B, this.opcodeAddr)) {
                        return -1;
                    }
                    n2 = iDasmRegs.getRegS(Operand.REG_B, this.opcodeAddr);
                    break;
                }
                case 134: {
                    this.line.append("A,").append(string);
                    if (!iDasmRegs.isAvailable(Operand.REG_A, this.opcodeAddr)) {
                        return -1;
                    }
                    n2 = iDasmRegs.getRegS(Operand.REG_A, this.opcodeAddr);
                    break;
                }
                case 139: {
                    this.line.append("D,").append(string);
                    if (!iDasmRegs.isAvailable(Operand.REG_D, this.opcodeAddr)) {
                        return -1;
                    }
                    n2 = iDasmRegs.getRegS(Operand.REG_D, this.opcodeAddr);
                    break;
                }
                case 136: {
                    return this.appendIdxOffset(this.readS8(), operand);
                }
                case 137: {
                    return this.appendIdxOffset(this.readS16(), operand);
                }
                default: {
                    this.line.append("??,").append(string);
                    return -1;
                }
            }
        }
        return iDasmRegs.isAvailable(operand, this.opcodeAddr) ? n2 + iDasmRegs.getRegU(operand, this.opcodeAddr) : -1;
    }

    private StringBuffer appendRegName(Operand operand, StringBuffer stringBuffer) {
        if (operand == Operand.CONSTANT) {
            return stringBuffer.append("#$FFFF");
        }
        return stringBuffer.append(operand.getName());
    }

    private StringBuffer appendAddr(int n, boolean bl, boolean bl2, StringBuffer stringBuffer) {
        n &= 0xFFFF;
        if (this.binder != null) {
            String string = this.binder.getLabel(n);
            if (string != null) {
                stringBuffer.append(string);
                if (bl2) {
                    Utils.HEX(4, n, this.comment.append('$'));
                }
                return stringBuffer;
            }
            if (this.createLabels && this.mem.isValidArea(n, 1)) {
                this.binder.bind(n, String.valueOf(LABEL_HEADER) + Utils.HEX(4, n));
            }
        }
        stringBuffer.append('$');
        if (bl) {
            Utils.HEX(2, n & 0xFF, stringBuffer);
            if (bl2) {
                Utils.HEX(4, n, this.comment.append('$'));
            }
        } else {
            Utils.HEX(4, n, stringBuffer);
        }
        return stringBuffer;
    }

    private int appendIdxOffset(int n, Operand operand) {
        int n2 = n;
        if (n < 0) {
            this.line.append('-');
            n2 = -n;
        }
        if (n2 < 10) {
            this.line.append(n2);
        } else {
            Utils.HEX(1, n2, this.line.append('$'));
        }
        this.line.append(',').append(operand == Operand.REG_PC ? "PCR" : operand.getName());
        if (!this.regs.isAvailable(operand, this.opcodeAddr)) {
            return -1;
        }
        return operand == Operand.REG_PC ? n + this.fetchAt & 0xFFFF : n + this.regs.getRegU(operand, this.opcodeAddr) & 0xFFFF;
    }

    private StringBuffer appendComment(int n, StringBuffer stringBuffer) {
        String string;
        if (this.binder != null && (string = this.binder.getLabel(n)) != null) {
            return Utils.HEX(4, n, this.comment.append(string).append(" ($")).append(')');
        }
        return Utils.HEX(4, n, stringBuffer.append('$'));
    }

    private void appendBxxComment(Instruction instruction) {
        int n;
        if (this.regs != null && this.regs.isAvailable(Operand.REG_CC, this.opcodeAddr) && (n = instruction.getOpcode() & 0xFF) >= 34 && n <= 47) {
            if (this.comment.length() > 0) {
                this.comment.append(' ');
            }
            if (MC6809Sim.evalCondition(instruction, this.regs.getRegU(Operand.REG_CC, this.opcodeAddr))) {
                this.comment.append("+jump ");
            } else {
                this.comment.append("-pass ");
            }
        }
    }

    private int readS8() {
        int n = this.mem.readS8(this.fetchAt++);
        Utils.HEX(2, n & 0xFF, this.hexa.append('\u00b7'));
        return n;
    }

    private int readU8() {
        int n = this.mem.readU8(this.fetchAt++);
        Utils.HEX(2, n, this.hexa.append('\u00b7'));
        return n;
    }

    private int readS16() {
        int n = this.readS8();
        return n << 8 | this.readU8();
    }

    private int readU16() {
        int n = this.readU8();
        return n << 8 | this.readU8();
    }
}

